package cn.iocoder.foodnexus.module.order.dto;

import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author : yanghao
 * create at:  2025/9/22  15:32
 * @description: 客户信息
 */
@Data
public class CustomerOrderDTO {

    /**
     * id
     */
    private Long id;
    /**
     * 订单编号
     */
    private String code;
    /**
     * 订单状态
     *
     * 枚举 {@link CustomerOrderStatus}
     */
    private CustomerOrderStatus orderStatus;
    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 灶点id
     */
    private Long customerDeptId;
    /**
     * 收获仓库id
     */
    private Long warehouseId;
    /**
     * 收获库区id
     */
    private Long warehouseAreaId;
    /**
     * 仓库信息
     */
    private WarehouseInfo warehouseInfo;
    /**
     * 客户收货地址id
     */
    private Long addressId;
    /**
     * 客户收货地址info
     */
    private CustomerAddressInfo addressInfo;
    /**
     * 配送模式
     *
     * 枚举 {@link DeliveryMode}
     */
    private DeliveryMode deliveryMode;
    /**
     * 采购订单数
     */
    private Integer productCount;
    /**
     * 供应商数
     */
    private Integer supplierCount;
    /**
     * 预计配送开始时间
     */
    private LocalDateTime planDeliveryStartTime;
    /**
     * 预计配送结束时间
     */
    private LocalDateTime planDeliveryEndTime;
    /**
     * 订单总金额(分)
     */
    private Integer orderAmount;
    /**
     * 实际支付总金额(分)
     */
    private Integer actualAmount;
    /**
     * 配送公司
     */
    private String operCompany;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    private String creator;

    /**
     * 订单备注
     */
    private CustomerOrderRemark orderRemark;

    /**
     * 是否已评论
     */
    private Boolean hasScore;

}
