package cn.iocoder.foodnexus.module.operations.service.inquirecustomerpush;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.customer.ErpCustomerSimpleRespVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquirecustomerpush.vo.AppInquireCustomerPushPageReqVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquirecustomerpush.vo.AppInquireCustomerPushRespVO;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquirecustomerpush.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquirecustomerpush.InquireCustomerPushDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 询价推送-客户 Service 接口
 *
 * @author 超级管理员
 */
public interface InquireCustomerPushService {

    /**
     * 创建询价推送-客户
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createInquireCustomerPush(@Valid InquireCustomerPushSaveReqVO createReqVO);

    /**
     * 更新询价推送-客户
     *
     * @param updateReqVO 更新信息
     */
    void updateInquireCustomerPush(@Valid InquireCustomerPushSaveReqVO updateReqVO);

    /**
     * 删除询价推送-客户
     *
     * @param id 编号
     */
    void deleteInquireCustomerPush(Long id);

    /**
    * 批量删除询价推送-客户
    *
    * @param ids 编号
    */
    void deleteInquireCustomerPushListByIds(List<Long> ids);

    /**
     * 获得询价推送-客户
     *
     * @param id 编号
     * @return 询价推送-客户
     */
    InquireCustomerPushDO getInquireCustomerPush(Long id);

    /**
     * 获得询价推送-客户分页
     *
     * @param pageReqVO 分页查询
     * @return 询价推送-客户分页
     */
    PageResult<InquireCustomerPushDO> getInquireCustomerPushPage(InquireCustomerPushPageReqVO pageReqVO);

    default void addBatch(List<InquireCustomerPushSaveReqVO> list) {
        if (CommonUtil.isEmpty(list)) {
            return ;
        }
        list.forEach(this::createInquireCustomerPush);
    }

    /**
     * 客户确认
     * @param id
     */
    void confirm(Long id);

    /**
     * app 端 客户查询询价
     * @param pageReqVO
     * @return
     */
    PageResult<AppInquireCustomerPushRespVO> getAppInquireCustomerPushPage(AppInquireCustomerPushPageReqVO pageReqVO);

    List<ErpCustomerSimpleRespVO> getSimpCustomer(Long inquireId);

    Map<Long, List<ErpCustomerSimpleRespVO>> getSimpCustomerMap(Collection<Long> inquireIds);
}