package cn.iocoder.foodnexus.module.operations.service.deliverystaffcustomer;

import cn.hutool.core.collection.CollUtil;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.customer.ErpCustomerRespVO;
import cn.iocoder.foodnexus.module.erp.service.sale.ErpCustomerService;
import cn.iocoder.foodnexus.module.system.controller.admin.dept.vo.dept.DeptSimpleRespVO;
import cn.iocoder.foodnexus.module.system.service.dept.DeptService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaffcustomer.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.deliverystaffcustomer.DeliveryStaffCustomerDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.operations.dal.mysql.deliverystaffcustomer.DeliveryStaffCustomerMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.module.operations.enums.ErrorCodeConstants.*;

/**
 * 配送员客户绑定 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class DeliveryStaffCustomerServiceImpl implements DeliveryStaffCustomerService {

    @Resource
    private DeliveryStaffCustomerMapper deliveryStaffCustomerMapper;

    @Resource
    private ErpCustomerService customerService;

    @Autowired
    private DeptService deptService;

    @Override
    public Long createDeliveryStaffCustomer(DeliveryStaffCustomerSaveReqVO createReqVO) {
        // 插入
        DeliveryStaffCustomerDO deliveryStaffCustomer = BeanUtils.toBean(createReqVO, DeliveryStaffCustomerDO.class);
        deliveryStaffCustomerMapper.insert(deliveryStaffCustomer);

        // 返回
        return deliveryStaffCustomer.getId();
    }

    @Override
    public void updateDeliveryStaffCustomer(DeliveryStaffCustomerSaveReqVO updateReqVO) {
        // 校验存在
        validateDeliveryStaffCustomerExists(updateReqVO.getId());
        // 更新
        DeliveryStaffCustomerDO updateObj = BeanUtils.toBean(updateReqVO, DeliveryStaffCustomerDO.class);
        deliveryStaffCustomerMapper.updateById(updateObj);
    }

    @Override
    public void deleteDeliveryStaffCustomer(Long id) {
        // 校验存在
        validateDeliveryStaffCustomerExists(id);
        // 删除
        deliveryStaffCustomerMapper.deleteById(id);
    }

    @Override
        public void deleteDeliveryStaffCustomerListByIds(List<Long> ids) {
        // 删除
        deliveryStaffCustomerMapper.deleteByIds(ids);
        }


    private void validateDeliveryStaffCustomerExists(Long id) {
        if (deliveryStaffCustomerMapper.selectById(id) == null) {
            throw exception(DELIVERY_STAFF_CUSTOMER_NOT_EXISTS);
        }
    }

    @Override
    public DeliveryStaffCustomerDO getDeliveryStaffCustomer(Long id) {
        return deliveryStaffCustomerMapper.selectById(id);
    }

    @Override
    public List<ErpCustomerRespVO> queryCustomerListByDeliveryStaffId(Long staffId) {
        List<DeliveryStaffCustomerDO> list = deliveryStaffCustomerMapper.selectList(Wrappers.<DeliveryStaffCustomerDO>lambdaQuery()
                .eq(DeliveryStaffCustomerDO::getDeliveryStaffId, staffId)
                .eq(DeliveryStaffCustomerDO::getIsDept, Boolean.FALSE)
                .groupBy(DeliveryStaffCustomerDO::getTargetId));
        return BeanUtils.toBean(customerService.getCustomerList(list.stream().map(DeliveryStaffCustomerDO::getTargetId).toList()),
                ErpCustomerRespVO.class);
    }

    @Override
    public List<DeptSimpleRespVO> queryDeptListByStaffId(Long staffId) {
        List<DeliveryStaffCustomerDO> deliveryStaffCustomerDOS = deliveryStaffCustomerMapper.selectList(Wrappers.<DeliveryStaffCustomerDO>lambdaQuery()
                .eq(DeliveryStaffCustomerDO::getDeliveryStaffId, staffId)
                .eq(DeliveryStaffCustomerDO::getIsDept, Boolean.TRUE)
                .groupBy(DeliveryStaffCustomerDO::getTargetId));
        return BeanUtils.toBean(deptService.getDeptList(CommonUtil.listConvertSet(deliveryStaffCustomerDOS, DeliveryStaffCustomerDO::getTargetId)),
                DeptSimpleRespVO.class);
    }


}