package cn.iocoder.foodnexus.module.operations.dal.mysql.scoringweight;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.scoringweight.ScoringWeightDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.operations.controller.admin.scoringweight.vo.*;

/**
 * 评分权重 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface ScoringWeightMapper extends BaseMapperX<ScoringWeightDO> {

    default PageResult<ScoringWeightDO> selectPage(ScoringWeightPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<ScoringWeightDO>()
                .likeIfPresent(ScoringWeightDO::getScoreName, reqVO.getScoreName())
                .eqIfPresent(ScoringWeightDO::getWeightRatio, reqVO.getWeightRatio())
                .eqIfPresent(ScoringWeightDO::getIsDisplay, reqVO.getIsDisplay())
                .eqIfPresent(ScoringWeightDO::getUserSystem, reqVO.getUserSystem())
                .eqIfPresent(ScoringWeightDO::getSort, reqVO.getSort())
                .betweenIfPresent(ScoringWeightDO::getCreateTime, reqVO.getCreateTime())
                .eqIfPresent(ScoringWeightDO::getWebDisplay, reqVO.getWebDisplay())
                .orderByDesc(ScoringWeightDO::getId));
    }

}