package cn.iocoder.foodnexus.module.operations.dal.mysql.inquirepriceitem;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquirepriceitem.InquirePriceItemDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquirepriceitem.vo.*;

/**
 * 询价管理子 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface InquirePriceItemMapper extends BaseMapperX<InquirePriceItemDO> {

    default PageResult<InquirePriceItemDO> selectPage(InquirePriceItemPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<InquirePriceItemDO>()
                .eqIfPresent(InquirePriceItemDO::getInquireId, reqVO.getInquireId())
                .eqIfPresent(InquirePriceItemDO::getProductId, reqVO.getProductId())
                .eqIfPresent(InquirePriceItemDO::getCategoryId, reqVO.getCategoryId())
                .likeIfPresent(InquirePriceItemDO::getCategoryName, reqVO.getCategoryName())
                .eqIfPresent(InquirePriceItemDO::getMarketPrice, reqVO.getMarketPrice())
                .eqIfPresent(InquirePriceItemDO::getProductStandard, reqVO.getProductStandard())
                .eqIfPresent(InquirePriceItemDO::getProductUnit, reqVO.getProductUnit())
                .eqIfPresent(InquirePriceItemDO::getFloatingRate, reqVO.getFloatingRate())
                .eqIfPresent(InquirePriceItemDO::getFloatingPrice, reqVO.getFloatingPrice())
                .betweenIfPresent(InquirePriceItemDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(InquirePriceItemDO::getId));
    }

}