package cn.iocoder.foodnexus.module.operations.dal.mysql.inquireprice;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquireprice.InquirePriceDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquireprice.vo.*;

/**
 * 询价管理 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface InquirePriceMapper extends BaseMapperX<InquirePriceDO> {

    default PageResult<InquirePriceDO> selectPage(InquirePricePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<InquirePriceDO>()
                .likeIfPresent(InquirePriceDO::getInquiryName, reqVO.getInquiryName())
                .eqIfPresent(InquirePriceDO::getInquiryYearMonth, reqVO.getInquiryYearMonth())
                .eqIfPresent(InquirePriceDO::getIsPush, reqVO.getIsPush())
                .betweenIfPresent(InquirePriceDO::getCreateTime, reqVO.getCreateTime())
                .eqIfPresent(InquirePriceDO::getCreator, reqVO.getCreator())
                .orderByDesc(InquirePriceDO::getId));
    }

}