package cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaff.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.time.LocalDateTime;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 配送员信息新增/修改 Request VO")
@Data
public class DeliveryStaffSaveReqVO {

    @Schema(description = "主键ID", requiredMode = Schema.RequiredMode.REQUIRED, example = "15492")
    private Long id;

    @Schema(description = "姓名", requiredMode = Schema.RequiredMode.REQUIRED, example = "芋艿")
    @NotEmpty(message = "姓名不能为空")
    private String name;

    @Schema(description = "身份证号", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "身份证号不能为空")
    private String idNumber;

    @Schema(description = "联系方式")
    private String contact;

    @Schema(description = "在岗状态", example = "1")
    private String onDutyStatus;

    @Schema(description = "人员出生年份")
    private Integer staffYearBirth;

    @Schema(description = "健康状态", example = "1")
    private String healthStatus;

    @Schema(description = "驾驶证类型", example = "1")
    private String driverLicenseType;

    @Schema(description = "驾驶证有效期开始时间")
    private LocalDateTime licenseStartTime;

    @Schema(description = "驾驶证有效期结束时间")
    private LocalDateTime licenseEndTime;

    @Schema(description = "驾驶证状态", example = "1")
    private String driverLicenseStatus;

    @Schema(description = "健康证明文件路径")
    private String healthCertificateFile;

    @Schema(description = "机动车驾驶证图片路径")
    private String driverLicenseFile;

    @Schema(description = "备注", example = "你猜")
    private String remark;

}