package cn.iocoder.foodnexus.module.erp.service.product;

import java.util.*;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.erp.controller.admin.product.vo.*;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.product.ProductSupplierDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;

/**
 * 供应商关联商品 Service 接口
 *
 * @author 超级管理员
 */
public interface ProductSupplierService {

    /**
     * 创建供应商关联商品
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createProductSupplier(@Valid ProductSupplierSaveReqVO createReqVO);

    /**
     * 更新供应商关联商品
     *
     * @param updateReqVO 更新信息
     */
    void updateProductSupplier(@Valid ProductSupplierSaveReqVO updateReqVO);

    /**
     * 删除供应商关联商品
     *
     * @param id 编号
     */
    void deleteProductSupplier(Long id);

    /**
    * 批量删除供应商关联商品
    *
    * @param ids 编号
    */
    void deleteProductSupplierListByIds(List<Long> ids);

    /**
     * 获得供应商关联商品
     *
     * @param id 编号
     * @return 供应商关联商品
     */
    ProductSupplierDO getProductSupplier(Long id);

    /**
     * 获得供应商关联商品分页
     *
     * @param pageReqVO 分页查询
     * @return 供应商关联商品分页
     */
    PageResult<ProductSupplierDO> getProductSupplierPage(ProductSupplierPageReqVO pageReqVO);

    /**
     * @param supplierId
     * @return productId集合
     */
    List<Long> queryBySupplierId(Long supplierId);

    /**
     *
     * @param productId
     * @return supplierId集合
     */
    List<Long> queryByProductId(Long productId);

    Map<Long, List<ProductSupplierDO>> groupBySupplierId(Collection<Long> productIds);

    Map<Long, Long> getCountMap(Collection<Long> productIds);

    Long getCountByProductId(Long productId);
}