package cn.iocoder.foodnexus.module.erp.dal.mysql.purchase;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.query.MPJLambdaWrapperX;
import cn.iocoder.foodnexus.module.erp.api.enums.ErpDeliveryStatus;
import cn.iocoder.foodnexus.module.erp.controller.admin.purchase.vo.order.ErpPurchaseOrderPageReqVO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.purchase.ErpPurchaseOrderDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.purchase.ErpPurchaseOrderItemDO;
import cn.iocoder.foodnexus.module.erp.api.enums.ErpAuditStatus;
import cn.iocoder.foodnexus.module.erp.controller.admin.purchase.vo.order.SupplierMonthOrderPageReqVO;
import cn.iocoder.foodnexus.module.erp.controller.admin.purchase.vo.order.SupplierMonthOrderRespVO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.purchase.ErpPurchaseReturnDO;
import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import cn.iocoder.foodnexus.module.product.dal.dataobject.spu.ProductSpuDO;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.yulichang.query.MPJQueryWrapper;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * ERP 采购订单 Mapper
 *
 * @author 芋道源码
 */
@Mapper
public interface ErpPurchaseOrderMapper extends BaseMapperX<ErpPurchaseOrderDO> {

    default List<Map<String, Object>> selectCountGroupbyDeliveryStatus(ErpPurchaseOrderPageReqVO pageReqVO) {
        MPJLambdaWrapperX<ErpPurchaseOrderDO> query = this.query(pageReqVO);
        query.selectAs(ErpPurchaseOrderDO::getDeliveryStatus, "deliveryStatus");
        query.selectCount(ErpPurchaseOrderDO::getId, "orderCount");
        query.groupBy(ErpPurchaseOrderDO::getDeliveryStatus);
        return selectMaps(query);
    }

    default Long selectCount(ErpPurchaseOrderPageReqVO reqVO) {
        return selectJoinCount(this.query(reqVO));
    }

    default PageResult<ErpPurchaseOrderDO> selectPage(ErpPurchaseOrderPageReqVO reqVO) {

        return selectJoinPage(reqVO, ErpPurchaseOrderDO.class, this.query(reqVO));
    }

    default MPJLambdaWrapperX<ErpPurchaseOrderDO> query(ErpPurchaseOrderPageReqVO reqVO) {
        MPJLambdaWrapperX<ErpPurchaseOrderDO> query = new MPJLambdaWrapperX<ErpPurchaseOrderDO>()
                .likeIfPresent(ErpPurchaseOrderDO::getNo, reqVO.getNo())
                .eqIfPresent(ErpPurchaseOrderDO::getSupplierId, reqVO.getSupplierId())
                .betweenIfPresent(ErpPurchaseOrderDO::getOrderTime, reqVO.getOrderTime())
                .betweenIfPresent(ErpPurchaseOrderDO::getCreateTime, reqVO.getCreateTime())
                .eqIfPresent(ErpPurchaseOrderDO::getStatus, reqVO.getStatus())
                .likeIfPresent(ErpPurchaseOrderDO::getRemark, reqVO.getRemark())
                .eqIfPresent(ErpPurchaseOrderDO::getCreator, reqVO.getCreator())
                .eqIfPresent(ErpPurchaseOrderDO::getDeliveryStatus, reqVO.getDeliveryStatus())
                .inIfPresent(ErpPurchaseOrderDO::getDeliveryStatus, reqVO.getDeliveryStatusList())
                .eqIfPresent(ErpPurchaseOrderDO::getCustomerOrderId, reqVO.getCustomerOrderId())
                .orderByDesc(ErpPurchaseOrderDO::getId);
        // 入库状态。为什么需要 t. 的原因，是因为联表查询时，需要指定表名，不然会报 in_count 错误
        if (Objects.equals(reqVO.getInStatus(), ErpPurchaseOrderPageReqVO.IN_STATUS_NONE)) {
            query.eq(ErpPurchaseOrderDO::getInCount, 0);
        } else if (Objects.equals(reqVO.getInStatus(), ErpPurchaseOrderPageReqVO.IN_STATUS_PART)) {
            query.gt(ErpPurchaseOrderDO::getInCount, 0).apply("t.in_count < t.total_count");
        } else if (Objects.equals(reqVO.getInStatus(), ErpPurchaseOrderPageReqVO.IN_STATUS_ALL)) {
            query.apply("t.in_count = t.total_count");
        }
        if (CommonUtil.isNotEmpty(reqVO.getDeliveryMode())) {
            query.leftJoin("order_customer_order oco on t.customer_order_id = oco.id");
            query.eq("oco.delivery_mode", reqVO.getDeliveryMode().getKey());
        }
        // 退货状态
        if (Objects.equals(reqVO.getReturnStatus(), ErpPurchaseOrderPageReqVO.RETURN_STATUS_NONE)) {
            query.eq(ErpPurchaseOrderDO::getReturnCount, 0);
        } else if (Objects.equals(reqVO.getReturnStatus(), ErpPurchaseOrderPageReqVO.RETURN_STATUS_PART)) {
            query.gt(ErpPurchaseOrderDO::getReturnCount, 0).apply("t.return_count < t.total_count");
        } else if (Objects.equals(reqVO.getReturnStatus(), ErpPurchaseOrderPageReqVO.RETURN_STATUS_ALL)) {
            query.apply("t.return_count = t.total_count");
        }
        // 可采购入库
        if (Boolean.TRUE.equals(reqVO.getInEnable())) {
            query.eq(ErpPurchaseOrderDO::getStatus, ErpAuditStatus.APPROVE.getStatus())
                    .apply("t.in_count < t.total_count");
        }
        // 可采购退货
        if (Boolean.TRUE.equals(reqVO.getReturnEnable())) {
            query.eq(ErpPurchaseOrderDO::getStatus, ErpAuditStatus.APPROVE.getStatus())
                    .apply("t.return_count < t.in_count");
        }
        if (reqVO.getProductId() != null) {
            query.leftJoin(ErpPurchaseOrderItemDO.class, ErpPurchaseOrderItemDO::getOrderId, ErpPurchaseOrderDO::getId)
                    .eq(reqVO.getProductId() != null, ErpPurchaseOrderItemDO::getProductId, reqVO.getProductId())
                    .groupBy(ErpPurchaseOrderDO::getId); // 避免 1 对多查询，产生相同的 1
        }
        if (CommonUtil.isNotBlank(reqVO.getProductName())) {
            query.leftJoin(ErpPurchaseOrderItemDO.class, ErpPurchaseOrderItemDO::getOrderId, ErpPurchaseOrderDO::getId)
                    .leftJoin(ProductSpuDO.class, ProductSpuDO::getId, ErpPurchaseOrderItemDO::getProductId)
                    .like(ProductSpuDO::getName, reqVO.getProductName())
                    .groupBy(ErpPurchaseOrderDO::getId);
        }
        if (CommonUtil.isNotBlank(reqVO.getCreateMonth())) {
            String createMonth = reqVO.getCreateMonth().trim();
            String startOfMonth = createMonth + "-01 00:00:00";
            String[] parts = createMonth.split("-");
            int year = Integer.parseInt(parts[0]);
            int nextMonth = Integer.parseInt(parts[1]) + 1;
            String endOfMonth = nextMonth > 12 ?
                    (year + 1) + "-01-01 00:00:00" :
                    year + "-" + (nextMonth < 10 ? "0" + nextMonth : nextMonth) + "-01 00:00:00";

            query.ge(ErpPurchaseOrderDO::getCreateTime, startOfMonth)
                    .lt(ErpPurchaseOrderDO::getCreateTime, endOfMonth);
        }
        if (CommonUtil.isNotBlank(reqVO.getCustomerName())) {
            query.leftJoin("order_customer_order oco on oco.id = t.customer_order_id");
            query.leftJoin("erp_customer ec on ec.id = oco.customer_id");
            query.like("ec.`name`", reqVO.getCustomerName());
            query.groupBy(ErpPurchaseOrderDO::getId);
        }
        if (CommonUtil.isNotEmpty(reqVO.getPlanDeliveryStartTime())) {
            query.leftJoin("order_customer_order oco1 on oco1.id = t.customer_order_id");
            query.between("oco1.plan_delivery_start_time", reqVO.getPlanDeliveryStartTime()[0], reqVO.getPlanDeliveryStartTime()[1]);
            query.groupBy(ErpPurchaseOrderDO::getId);
        }
        if (CommonUtil.isNotBlank(reqVO.getContactPhone()) || CommonUtil.isNotBlank(reqVO.getContactUser())) {
            query.leftJoin("order_customer_order oco2 on oco2.id = t.customer_order_id");
            query.likeIfExists("oco2.address_info", reqVO.getContactPhone());
            query.likeIfExists("oco2.address_info", reqVO.getContactUser());
        }
        if (CommonUtil.isNotBlank(reqVO.getCustomerOrderCode())) {
            query.leftJoin("order_customer_order oco3 on oco3.id = t.customer_order_id");
            query.eq("oco3.code", reqVO.getCustomerOrderCode());
            query.groupBy(ErpPurchaseReturnDO::getId);
        }
        return query;
    }

    default int updateByIdAndStatus(Long id, Integer status, ErpPurchaseOrderDO updateObj) {
        return update(updateObj, new LambdaUpdateWrapper<ErpPurchaseOrderDO>()
                .eq(ErpPurchaseOrderDO::getId, id).eq(ErpPurchaseOrderDO::getStatus, status));
    }

    default ErpPurchaseOrderDO selectByNo(String no) {
        return selectOne(ErpPurchaseOrderDO::getNo, no);
    }

    default PageResult<SupplierMonthOrderRespVO> pageMonth(SupplierMonthOrderPageReqVO pageReqVO, Long supplierId) {
        MPJQueryWrapper<ErpPurchaseOrderDO> wrapper = new MPJQueryWrapper<>();
        wrapper.select("t.supplier_id");
        wrapper.select("es.name as 'supplier_name'");
        wrapper.select("DATE_FORMAT( t.create_time, '%Y-%m' ) AS 'month'");
        wrapper.select("count( t.id ) AS 'orderCount'");
        wrapper.select("SUM( t.total_price ) AS 'orderPrice'");
        // TODO payablePrice 这个字段待定
        wrapper.select("CASE WHEN SUM(CASE WHEN t.delivery_status='ARRIVAL' THEN 1 ELSE 0 END)> 0 THEN 0 ELSE 1 END AS 'status'");
        wrapper.leftJoin("order_customer_order t1 on t.customer_order_id = t1.id");
        wrapper.leftJoin("erp_supplier es on t.supplier_id = es.id");
        wrapper.eq(CommonUtil.isNotEmpty(supplierId), "t.supplier_id", supplierId);
        wrapper.in("t.delivery_status", CommonUtil.asList(ErpDeliveryStatus.RECONCILIATION.getStatus(),
                ErpDeliveryStatus.ARRIVAL.getStatus()));
        wrapper.in("t1.order_status", CommonUtil.asList(CustomerOrderStatus.SIGN_RECEIPT.getKey()), CustomerOrderStatus.FINISH.getKey());

        wrapper.eq(CommonUtil.isNotBlank(pageReqVO.getMonth()), "DATE_FORMAT(t.create_time, '%Y-%m') ", pageReqVO.getMonth());
        wrapper.orderByDesc("t.id");
        wrapper.groupBy("DATE_FORMAT( t.create_time, '%Y-%m' ), t.supplier_id");
        return this.selectJoinPage(pageReqVO, SupplierMonthOrderRespVO.class, wrapper);

    }
}