package cn.iocoder.foodnexus.module.erp.dal.mysql.product;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.product.ProductSupplierDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.erp.controller.admin.product.vo.*;

/**
 * 供应商关联商品 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface ProductSupplierMapper extends BaseMapperX<ProductSupplierDO> {

    default PageResult<ProductSupplierDO> selectPage(ProductSupplierPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<ProductSupplierDO>()
                .eqIfPresent(ProductSupplierDO::getProductId, reqVO.getProductId())
                .eqIfPresent(ProductSupplierDO::getSupplierId, reqVO.getSupplierId())
                .betweenIfPresent(ProductSupplierDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(ProductSupplierDO::getId));
    }

}