package cn.iocoder.foodnexus.module.erp.controller.admin.customerwarehouse.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 客户绑定仓库分页 Request VO")
@Data
public class CustomerWarehousePageReqVO extends PageParam {

    @Schema(description = "客户id", example = "24072")
    private Long customerId;

    @Schema(description = "仓库id", example = "30163")
    private Long warehouseId;

    @Schema(description = "库区id", example = "18079")
    private Long warehouseAreaId;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}