package cn.iocoder.foodnexus.module.system.controller.admin.province.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 地区数据 Response VO")
@Data
@ExcelIgnoreUnannotated
public class ProvinceRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "17532")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "父级id", requiredMode = Schema.RequiredMode.REQUIRED, example = "21246")
    @ExcelProperty("父级id")
    private Long parentId;

    @Schema(description = "名称", example = "张三")
    @ExcelProperty("名称")
    private String fullName;

    @Schema(description = "quickQuery")
    @ExcelProperty("quickQuery")
    private String quickQuery;

    @Schema(description = "类型（1-省份 2-市 3-县 4-街道）", requiredMode = Schema.RequiredMode.REQUIRED, example = "2")
    @ExcelProperty("类型（1-省份 2-市 3-县 4-街道）")
    private Integer type;

}