package cn.iocoder.foodnexus.module.order.service.customerorderrecord;

import java.util.*;

import cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo.CustomerOrderRecordMapVO;
import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorderrecord.vo.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorderrecord.CustomerOrderRecordDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 客户订单进度记录 Service 接口
 *
 * @author 超级管理员
 */
public interface CustomerOrderRecordService {

    /**
     * 创建客户订单进度记录
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createCustomerOrderRecord(@Valid CustomerOrderRecordSaveReqVO createReqVO);

    /**
     * 更新客户订单进度记录
     *
     * @param updateReqVO 更新信息
     */
    void updateCustomerOrderRecord(@Valid CustomerOrderRecordSaveReqVO updateReqVO);

    /**
     * 删除客户订单进度记录
     *
     * @param id 编号
     */
    void deleteCustomerOrderRecord(Long id);

    /**
    * 批量删除客户订单进度记录
    *
    * @param ids 编号
    */
    void deleteCustomerOrderRecordListByIds(List<Long> ids);

    /**
     * 获得客户订单进度记录
     *
     * @param id 编号
     * @return 客户订单进度记录
     */
    CustomerOrderRecordDO getCustomerOrderRecord(Long id);

    /**
     * 获得客户订单进度记录分页
     *
     * @param pageReqVO 分页查询
     * @return 客户订单进度记录分页
     */
    PageResult<CustomerOrderRecordDO> getCustomerOrderRecordPage(CustomerOrderRecordPageReqVO pageReqVO);

    /**
     * 订单进度记录
     * @param customerOrderId
     * @return
     */
    List<CustomerOrderRecordMapVO> queryRecordMap(Long customerOrderId);

    List<CustomerOrderRecordRespVO> queryCurrentRecords(Long customerOrderId, CustomerOrderStatus orderStatus);
}