package cn.iocoder.foodnexus.module.order.service.checktaskitems;

import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.CheckTaskItemsPageReqVO;
import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.CheckTaskItemsSaveReqVO;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;

import java.util.*;
import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.checktaskitems.CheckTaskItemsDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.order.dal.mysql.checktaskitems.CheckTaskItemsMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.convertList;

/**
 * 来料质检清单 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class CheckTaskItemsServiceImpl implements CheckTaskItemsService {

    @Resource
    private CheckTaskItemsMapper checkTaskItemsMapper;

    @Override
    public Long createCheckTaskItems(CheckTaskItemsSaveReqVO createReqVO) {
        // 插入
        CheckTaskItemsDO checkTaskItems = BeanUtils.toBean(createReqVO, CheckTaskItemsDO.class);
        checkTaskItemsMapper.insert(checkTaskItems);

        // 返回
        return checkTaskItems.getId();
    }

    @Override
    public void updateCheckTaskItems(CheckTaskItemsSaveReqVO updateReqVO) {
        // 更新
        CheckTaskItemsDO updateObj = BeanUtils.toBean(updateReqVO, CheckTaskItemsDO.class);
        checkTaskItemsMapper.updateById(updateObj);
    }

    @Override
    public void deleteCheckTaskItems(Long id) {
        // 删除
        checkTaskItemsMapper.deleteById(id);
    }

    @Override
    public void deleteCheckTaskItemsListByIds(List<Long> ids) {
        // 删除
        checkTaskItemsMapper.deleteByIds(ids);
    }


    @Override
    public CheckTaskItemsDO getCheckTaskItems(Long id) {
        return checkTaskItemsMapper.selectById(id);
    }

    @Override
    public PageResult<CheckTaskItemsDO> getCheckTaskItemsPage(CheckTaskItemsPageReqVO pageReqVO) {
        return checkTaskItemsMapper.selectPage(pageReqVO);
    }

    @Override
    public List<CheckTaskItemsDO> queryByCheckId(Long id) {
        return checkTaskItemsMapper.selectList(CheckTaskItemsDO::getCheckTaskId, id);
    }

    @Override
    public Map<Long, String> queryProductInfoByCheckId(Collection<Long> checkIds) {
        Map<Long, String> resultMap = new HashMap<>();
        if (CommonUtil.isEmpty(checkIds)) {
            return resultMap;
        }
        List<CheckTaskItemsDO> checkTaskItemsDOS = checkTaskItemsMapper.selectList(Wrappers.<CheckTaskItemsDO>lambdaQuery()
                .in(CheckTaskItemsDO::getCheckTaskId, checkIds));

        if (CommonUtil.isEmpty(checkTaskItemsDOS)) {
            return resultMap;
        }
        Map<Long, List<CheckTaskItemsDO>> itemMap = CommonUtil.listConvertListMap(checkTaskItemsDOS, CheckTaskItemsDO::getCheckTaskId);
        itemMap.forEach((checkId, list) -> resultMap.put(checkId,
                String.join("，", CommonUtil.listConvert(list, item -> item.getProductName() + "(" + item.getCheckCount() + ")"))));

        return resultMap;
    }

}