package cn.iocoder.foodnexus.module.order.enums;

import cn.iocoder.foodnexus.framework.common.exception.ErrorCode;

/**
 * Product 错误码枚举类
 *
 * product 系统，使用 1-008-000-000 段
 */
public interface ErrorCodeConstants {
    // ========== 购物车 1_018-000-000 ==========
    ErrorCode SHOPPING_CART_NOT_EXISTS = new ErrorCode(1_018_100_000, "购物车不存在");
    ErrorCode PRODUCT_DISABLE = new ErrorCode(1_018_100_001, "商品【{}】已下架");

    // ========== 客户总订单 1_019_100_0001 ==========
    ErrorCode CUSTOMER_ORDER_NOT_EXISTS = new ErrorCode(1_019_100_001, "客户总订单不存在");
    ErrorCode CUSTOMER_ORDER_WAREHOUSE_NOEXISTS = new ErrorCode(1_019_100_002, "仓库不存在");
    ErrorCode CUSTOMER_WAREHOUSE_NOT_BIND = new ErrorCode(1_019_100_003, "所选仓库未绑定");
    ErrorCode CUSTOMER_ORDER_ADDRESS_NOEXISTS = new ErrorCode(1_019_100_004, "仓库不存在");
    ErrorCode CUSTOMER_ORDER_STATUS_ERROR = new ErrorCode(1_019_100_005, "客户订单状态异常");
    ErrorCode CUSTOMER_ORDER_OUT_ERROR = new ErrorCode(1_019_100_006, "客户订单出库环节异常");
    ErrorCode CUSTOMER_ORDER_RETURN_PRODUCT_ERROR = new ErrorCode(1_019_100_006, "客户订单退货商品异常");
    ErrorCode CUSTOMER_ORDER_RETURN_COUNT_ERROR= new ErrorCode(1_019_100_007, "商品{}退货数量异常");
    ErrorCode CUSTOMER_ORDER_HAS_RECEIPT = new ErrorCode(1_019_100_006, "客户订单已评价");
    ErrorCode CUSTOMER_ORDER_HAS_FINISH = new ErrorCode(1_019_100_007, "客户订单【{}】已确认");

    // ========== 客户订单-子订单 1_020_100_0001 ==========
    ErrorCode CUSTOMER_ORDER_ITEM_NOT_EXISTS = new ErrorCode(1_020_100_001, "客户订单-子订单不存在");


    // ========== 客户订单进度记录 1_021_100_001 ==========
    ErrorCode CUSTOMER_ORDER_RECORD_NOT_EXISTS = new ErrorCode(1_021_100_001, "客户订单进度记录不存在");

    // ========== 客户 - 我的地址 1_022_100_001 ==========
    ErrorCode CUSTOMER_ADDRESS_NOT_EXISTS = new ErrorCode(1_022_100_001, "客户 - 我的地址不存在");

    // ========== 来料质检 1_023_100_001 ==========
    ErrorCode CHECK_TASK_NOT_EXISTS = new ErrorCode(1_023_100_001, "来料质检不存在");
    ErrorCode CHECK_TASK_CREATE_ERROR = new ErrorCode(1_023_100_002, "来料质检新增失败");
    ErrorCode CHECK_TASK_STATUS_ERROR = new ErrorCode(1_023_100_003, "来料质检已质检");
    ErrorCode CHECK_TASK_TO_BE_CHECK = new ErrorCode(1_023_100_003, "请先完成质检");
    ErrorCode CHECK_TASK_PURCHASE_ORDER_NOT_EXISTS = new ErrorCode(1_023_100_004, "关联采购订单不存在");
    ErrorCode CHECK_TASK_PURCHASE_ORDER_STATUS_ERROR = new ErrorCode(1_023_100_005, "关联采购订单未到货");

    // ========== 订单评价 1_024_100_001 ==========
    ErrorCode SCORE_NOT_EXISTS = new ErrorCode(1_024_100_001, "订单评价不存在");
    ErrorCode SCORE_EXISTS = new ErrorCode(1_024_100_002, "订单评价已存在");
}
