package cn.iocoder.foodnexus.module.order.dal.mysql.shoppingcart;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.order.controller.app.shoppingcart.vo.ShoppingCartPageReqVO;
import cn.iocoder.foodnexus.module.order.dal.dataobject.shoppingcart.ShoppingCartDO;
import org.apache.ibatis.annotations.Mapper;

/**
 * 购物车 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface ShoppingCartMapper extends BaseMapperX<ShoppingCartDO> {

    default PageResult<ShoppingCartDO> selectPage(ShoppingCartPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<ShoppingCartDO>()
                .eqIfPresent(ShoppingCartDO::getProductId, reqVO.getProductId())
                .likeIfPresent(ShoppingCartDO::getProductName, reqVO.getProductName())
                .eqIfPresent(ShoppingCartDO::getUnitPrice, reqVO.getUnitPrice())
                .eqIfPresent(ShoppingCartDO::getOrderQuantity, reqVO.getOrderQuantity())
                .eqIfPresent(ShoppingCartDO::getRemark, reqVO.getRemark())
                .betweenIfPresent(ShoppingCartDO::getCreateTime, reqVO.getCreateTime())
                .eq(ShoppingCartDO::getCreator, reqVO.getCreator())
                .orderByDesc(ShoppingCartDO::getId));
    }

}