package cn.iocoder.foodnexus.module.order.dal.mysql.customerorderitem;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorderitem.CustomerOrderItemDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorderitem.vo.*;

/**
 * 客户订单-子订单 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface CustomerOrderItemMapper extends BaseMapperX<CustomerOrderItemDO> {

    default PageResult<CustomerOrderItemDO> selectPage(CustomerOrderItemPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<CustomerOrderItemDO>()
                .eqIfPresent(CustomerOrderItemDO::getOrderId, reqVO.getOrderId())
                .eqIfPresent(CustomerOrderItemDO::getCustomerId, reqVO.getCustomerId())
                .eqIfPresent(CustomerOrderItemDO::getProductId, reqVO.getProductId())
                .likeIfPresent(CustomerOrderItemDO::getProductName, reqVO.getProductName())
                .eqIfPresent(CustomerOrderItemDO::getProductInfo, reqVO.getProductInfo())
                .eqIfPresent(CustomerOrderItemDO::getSupplierId, reqVO.getSupplierId())
                .likeIfPresent(CustomerOrderItemDO::getSupplierName, reqVO.getSupplierName())
                .betweenIfPresent(CustomerOrderItemDO::getCreateTime, reqVO.getCreateTime())
                .eqIfPresent(CustomerOrderItemDO::getOrderItemPrice, reqVO.getOrderItemPrice())
                .eqIfPresent(CustomerOrderItemDO::getOrderItemTotal, reqVO.getOrderItemTotal())
                .eqIfPresent(CustomerOrderItemDO::getOrderItemQuantity, reqVO.getOrderItemQuantity())
                .eqIfPresent(CustomerOrderItemDO::getSignedQuantity, reqVO.getSignedQuantity())
                .eqIfPresent(CustomerOrderItemDO::getSignedTotal, reqVO.getSignedTotal())
                .orderByDesc(CustomerOrderItemDO::getId));
    }

}