package cn.iocoder.foodnexus.module.order.dal.dataobject.orderScore;

import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 订单评价 DO
 *
 * @author 超级管理员
 */
@TableName(value = "order_score", autoResultMap = true)
@KeySequence("order_score_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OrderScoreDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 客户订单id
     */
    private Long orderId;
    /**
     * 评价指标id
     */
    private Long scoreId;
    /**
     * 评价指标名称
     */
    private String scoreName;
    /**
     * 供应商id
     */
    private Long supplierId;
    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 得分
     */
    private Integer score;
    /**
     * 排序
     */
    private Integer sort;


}