package cn.iocoder.foodnexus.module.order.controller.app.delivery.vo;

import cn.idev.excel.annotation.ExcelProperty;
import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.erp.enums.SaleOrderPickUpStatus;
import cn.iocoder.foodnexus.module.order.dto.CustomerAddressInfo;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author : yanghao
 * create at:  2025/10/14  18:16
 * @description: 配送员 - 销售订单
 */
@Data
public class DeliverySaleOrderRespVO {

    @Schema(description = "编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "17386")
    @ExcelProperty("编号")
    private Long id;

    @Schema(description = "销售单编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "XS001")
    @ExcelProperty("销售单编号")
    private String no;

    @Schema(description = "客户编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "1724")
    private Long customerId;

    @Schema(description = "客户名称", example = "芋道")
    @ExcelProperty("客户名称")
    private String customerName;

    @Schema(description = "下单时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("下单时间")
    private LocalDateTime orderTime;

    @Schema(description = "客户订单id")
    private Long customerOrderId;

    @Schema(description = "配送模式")
    private DeliveryMode deliveryMode;

    @Schema(description = "配送时间（取货时间）")
    private LocalDateTime deliveryTime;

    @Schema(description = "接单时间")
    private LocalDateTime acceptTime;

    @Schema(description = "送达时间")
    private LocalDateTime arrivalTime;

    @Schema(description = "客户签收时间")
    private LocalDateTime signTime;

    @Schema(description = "客户收货地址id")
    private Long addressId;

    @Schema(description = "客户收货地址info")
    @TableField(typeHandler = JacksonTypeHandler.class)
    private CustomerAddressInfo addressInfo;

    @Schema(description = "拣货状态")
    private SaleOrderPickUpStatus pickUpStatus;

    @Schema(description = "收获仓库id", requiredMode = Schema.RequiredMode.REQUIRED, example = "27065")
    private Long warehouseId;

    @Schema(description = "收获库区id", requiredMode = Schema.RequiredMode.REQUIRED, example = "26507")
    private Long warehouseAreaId;

    @Schema(description = "仓库信息")
    private WarehouseInfo warehouseInfo;


    @Schema(description = "预计配送开始时间")
    private LocalDateTime planDeliveryStartTime;

    @Schema(description = "预计配送结束时间")
    private LocalDateTime planDeliveryEndTime;

}
