package cn.iocoder.foodnexus.module.order.controller.app.delivery.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/11/4  15:10
 * @description:
 */
@Data
public class DeliveryOrderArrivalDetails {

    @Schema(description = "客户订单子项id")
    private Long customerOrderItemId;

    @Schema(description = "配送单/退货单 子项编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "11756")
    private Long orderItemId;

    @Schema(description = "签收数量", requiredMode = Schema.RequiredMode.REQUIRED, example = "100.00")
    private BigDecimal count;

    @Schema(description = "备注", example = "随便")
    private String remark;

    @Schema(description = "相关文件")
    private List<String> remarkFiles;

}
