package cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/9/24  15:51
 * @description: 订单备注
 */
@Data
public class AppCustomerOrderReceiptRespVO {

    @Schema(description = "商品id")
    private Long productId;

    @Schema(description = "实际签收数量")
    private Integer signedQuantity;

    @Schema(description = "签收总价，单位：分")
    private Integer signedTotal;

    @Schema(description = "说明")
    private String remark;

    @Schema(description = "相关文件")
    private List<String> remarkFiles;

}
