package cn.iocoder.foodnexus.module.order.controller.admin.orderScore.vo;

import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 订单评价分页 Request VO")
@Data
public class OrderScoreSupplierPageReqVO extends PageParam {

    @Schema(description = "year")
    @NotNull(message = "评分年度不能为空")
    private String year;

    @Schema(description = "供应商id")
    private Long id;

    @Schema(description = "供应商名称", example = "芋道源码")
    private String name;

    @Schema(description = "手机号码", example = "15601691300")
    private String mobile;

    @Schema(description = "联系电话", example = "18818288888")
    private String telephone;

    @Schema(description = "联系人")
    private String contact;

    @Schema(description = "统一社会信用代码")
    private String unifiedSocialCreditCode;

    @Schema(description = "ids")
    private List<Long> idList;

}