package cn.iocoder.foodnexus.module.order.controller.admin.orderScore;

import org.springframework.web.bind.annotation.*;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Operation;

import jakarta.validation.constraints.*;
import jakarta.validation.*;
import jakarta.servlet.http.*;
import java.util.*;
import java.io.IOException;

import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

import cn.iocoder.foodnexus.framework.excel.core.util.ExcelUtils;

import cn.iocoder.foodnexus.framework.apilog.core.annotation.ApiAccessLog;
import static cn.iocoder.foodnexus.framework.apilog.core.enums.OperateTypeEnum.*;

import cn.iocoder.foodnexus.module.order.controller.admin.orderScore.vo.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.orderScore.OrderScoreDO;
import cn.iocoder.foodnexus.module.order.service.orderScore.OrderScoreService;

@Tag(name = "管理后台 - 供应商信用评分")
@RestController
@RequestMapping("/order/score")
@Validated
public class OrderScoreController {

    @Resource
    private OrderScoreService scoreService;

    @GetMapping("/supplier/page")
    @Operation(summary = "获得订单评价分页")
    public CommonResult<PageResult<OrderScoreSupplierRespVO>> supplierPage(@Valid OrderScoreSupplierPageReqVO pageReqVO) {
        return success(scoreService.supplierPage(pageReqVO));
    }

    @GetMapping("/customer/get-by-customer-order-id")
    @Operation(summary = "根据客户订单id查询对应评价")
    @Parameter(name = "customerOrderId", description = "编号", required = true)
    public CommonResult<List<OrderScoreRespVO>> getByCustomerOrderId(@RequestParam("customerOrderId") Long customerOrderId) {
        return success(BeanUtils.toBean(scoreService.listByOrderId(customerOrderId), OrderScoreRespVO.class));
    }

    /*@PostMapping("/create")
    @Operation(summary = "创建订单评价")
    @PreAuthorize("@ss.hasPermission('order:score:create')")
    public CommonResult<Long> createScore(@Valid @RequestBody OrderScoreSaveReqVO createReqVO) {
        return success(scoreService.createScore(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新订单评价")
    @PreAuthorize("@ss.hasPermission('order:score:update')")
    public CommonResult<Boolean> updateScore(@Valid @RequestBody OrderScoreSaveReqVO updateReqVO) {
        scoreService.updateScore(updateReqVO);
        return success(true);
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除订单评价")
    @Parameter(name = "id", description = "编号", required = true)
    @PreAuthorize("@ss.hasPermission('order:score:delete')")
    public CommonResult<Boolean> deleteScore(@RequestParam("id") Long id) {
        scoreService.deleteScore(id);
        return success(true);
    }

    @DeleteMapping("/delete-list")
    @Parameter(name = "ids", description = "编号", required = true)
    @Operation(summary = "批量删除订单评价")
                @PreAuthorize("@ss.hasPermission('order:score:delete')")
    public CommonResult<Boolean> deleteScoreList(@RequestParam("ids") List<Long> ids) {
        scoreService.deleteScoreListByIds(ids);
        return success(true);
    }*/

   /* @GetMapping("/get")
    @Operation(summary = "获得订单评价")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    @PreAuthorize("@ss.hasPermission('order:score:query')")
    public CommonResult<OrderScoreRespVO> getScore(@RequestParam("id") Long id) {
        OrderScoreDO score = scoreService.getScore(id);
        return success(BeanUtils.toBean(score, OrderScoreRespVO.class));
    }

    @GetMapping("/page")
    @Operation(summary = "获得订单评价分页")
    @PreAuthorize("@ss.hasPermission('order:score:query')")
    public CommonResult<PageResult<OrderScoreRespVO>> getScorePage(@Valid OrderScorePageReqVO pageReqVO) {
        PageResult<OrderScoreDO> pageResult = scoreService.getScorePage(pageReqVO);
        return success(BeanUtils.toBean(pageResult, OrderScoreRespVO.class));
    }

    @GetMapping("/export-excel")
    @Operation(summary = "导出订单评价 Excel")
    @PreAuthorize("@ss.hasPermission('order:score:export')")
    @ApiAccessLog(operateType = EXPORT)
    public void exportScoreExcel(@Valid OrderScorePageReqVO pageReqVO,
              HttpServletResponse response) throws IOException {
        pageReqVO.setPageSize(PageParam.PAGE_SIZE_NONE);
        List<OrderScoreDO> list = scoreService.getScorePage(pageReqVO).getList();
        // 导出 Excel
        ExcelUtils.write(response, "订单评价.xls", "数据", OrderScoreRespVO.class,
                        BeanUtils.toBean(list, OrderScoreRespVO.class));
    }*/

}