package cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo;

import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.order.dto.CustomerAddressInfo;
import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 客户总订单新增/修改 Request VO")
@Data
public class CustomerOrderSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "19291")
    private Long id;

    @Schema(description = "订单编号", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "订单编号不能为空")
    private String code;

    @Schema(description = "订单状态", requiredMode = Schema.RequiredMode.REQUIRED, example = "2")
    @NotEmpty(message = "订单状态不能为空")
    private CustomerOrderStatus orderStatus;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "20189")
    @NotNull(message = "客户id不能为空")
    private Long customerId;

    @Schema(description = "灶点id")
    private Long customerDeptId;

    @Schema(description = "收获仓库id", requiredMode = Schema.RequiredMode.REQUIRED, example = "27065")
    @NotNull(message = "收获仓库id不能为空")
    private Long warehouseId;

    @Schema(description = "收获库区id", requiredMode = Schema.RequiredMode.REQUIRED, example = "26507")
    @NotNull(message = "收获库区id不能为空")
    private Long warehouseAreaId;

    @Schema(description = "仓库信息")
    private WarehouseInfo warehouseInfo;

    @Schema(description = "客户收货地址id")
    private Long addressId;

    @Schema(description = "客户收货地址info")
    private CustomerAddressInfo addressInfo;

    @Schema(description = "配送模式", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "配送模式不能为空")
    private DeliveryMode deliveryMode;

    @Schema(description = "采购订单数", requiredMode = Schema.RequiredMode.REQUIRED, example = "12099")
    @NotNull(message = "采购订单数不能为空")
    private Integer productCount;

    @Schema(description = "供应商数", example = "8062")
    private Integer supplierCount;

    @Schema(description = "预计配送开始时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime planDeliveryStartTime;

    @Schema(description = "预计配送结束时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime planDeliveryEndTime;

    @Schema(description = "订单总金额(分)", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "订单总金额(分)不能为空")
    private Integer orderAmount;

    @Schema(description = "实际支付总金额(分)")
    private Integer actualAmount;

    @Schema(description = "配送公司")
    private String operCompany;

}