package cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 来料质检清单新增/修改 Request VO")
@Data
public class CheckTaskItemsSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "5717")
    private Long id;

    @Schema(description = "来料质检id", requiredMode = Schema.RequiredMode.REQUIRED, example = "31590")
    @NotNull(message = "来料质检id不能为空")
    private Long checkTaskId;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "30398")
    @NotNull(message = "商品id不能为空")
    private Long productId;

    @Schema(description = "商品名称", example = "王五")
    private String productName;

    @Schema(description = "采购订单子id")
    private Long purchaseOrderItemId;

    @Schema(description = "商品分类", example = "20330")
    private Long categoryId;

    @Schema(description = "商品分类名称", example = "王五")
    private String categoryName;

    @Schema(description = "商品封面图", requiredMode = Schema.RequiredMode.REQUIRED, example = "https://www.iocoder.cn")
    // @NotEmpty(message = "商品封面图不能为空")
    private String picUrl;

    @Schema(description = "检查数量", requiredMode = Schema.RequiredMode.REQUIRED, example = "24148")
    @NotNull(message = "检查数量不能为空")
    private Integer checkCount;

    @Schema(description = "商品单位", example = "李四")
    private String unitName;

    @Schema(description = "质检结果", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "质检结果不能为空")
    private String checkResult;

}