package cn.iocoder.foodnexus.module.operations.dal.dataobject.inquireprice;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 询价管理 DO
 *
 * @author 超级管理员
 */
@TableName("oper_inquire_price")
@KeySequence("oper_inquire_price_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InquirePriceDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 询价主题
     */
    private String inquiryName;
    /**
     * 询价年月
     */
    private String inquiryYearMonth;
    /**
     * 是否推送
     */
    private Boolean isPush;


}