package cn.iocoder.foodnexus.module.operations.dal.dataobject.deliverystaff;

import lombok.*;

import java.time.LocalDate;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 配送员信息 DO
 *
 * @author 超级管理员
 */
@TableName("oper_delivery_staff")
@KeySequence("oper_delivery_staff_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DeliveryStaffDO extends BaseDO {

    /**
     * 主键ID
     */
    @TableId
    private Long id;
    /**
     * 姓名
     */
    private String name;
    /**
     * 身份证号
     */
    private String idNumber;
    /**
     * 联系方式
     */
    private String contact;
    /**
     * 在岗状态
     *
     * 枚举 {@link TODO oper_on_duty_status 对应的类}
     */
    private String onDutyStatus;
    /**
     * 人员出生年份
     */
    private Integer staffYearBirth;
    /**
     * 健康状态
     *
     * 枚举 {@link TODO oper_health_status 对应的类}
     */
    private String healthStatus;
    /**
     * 驾驶证类型
     */
    private String driverLicenseType;
    /**
     * 驾驶证有效期开始时间
     */
    private LocalDateTime licenseStartTime;
    /**
     * 驾驶证有效期结束时间
     */
    private LocalDateTime licenseEndTime;
    /**
     * 驾驶证状态
     *
     * 枚举 {@link TODO oper_normal_status 对应的类}
     */
    private String driverLicenseStatus;
    /**
     * 健康证明文件路径
     */
    private String healthCertificateFile;
    /**
     * 机动车驾驶证图片路径
     */
    private String driverLicenseFile;
    /**
     * 备注
     */
    private String remark;
    /**
     * 关联系统用户id
     */
    private Long userId;


}