package cn.iocoder.foodnexus.module.operations.controller.app.customerrequire;

import cn.iocoder.foodnexus.framework.apilog.core.annotation.ApiAccessLog;
import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.common.util.collection.MapUtils;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import cn.iocoder.foodnexus.framework.excel.core.util.ExcelUtils;
import cn.iocoder.foodnexus.framework.security.core.util.SecurityFrameworkUtils;
import cn.iocoder.foodnexus.module.erp.api.service.ErpCustomerApi;
import cn.iocoder.foodnexus.module.erp.service.product.ErpProductService;
import cn.iocoder.foodnexus.module.operations.controller.admin.customerrequire.vo.CustomerRequirePageReqVO;
import cn.iocoder.foodnexus.module.operations.controller.admin.customerrequire.vo.CustomerRequireRespVO;
import cn.iocoder.foodnexus.module.operations.controller.admin.customerrequire.vo.CustomerRequireSaveReqVO;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.customerrequire.CustomerRequireDO;
import cn.iocoder.foodnexus.module.operations.service.customerrequire.CustomerRequireService;
import cn.iocoder.foodnexus.module.product.service.category.ProductCategoryService;
import cn.iocoder.foodnexus.module.system.annotations.AppSystemAuth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import static cn.iocoder.foodnexus.framework.apilog.core.enums.OperateTypeEnum.EXPORT;
import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

@Tag(name = "APP - 客户需求")
@RestController
@RequestMapping("/oper/customer-require")
@Validated
@AppSystemAuth(UserSystemEnum.CUSTOMER)
public class AppCustomerRequireController {

    @Resource
    private CustomerRequireService customerRequireService;

    @Autowired
    private ErpCustomerApi customerApi;

    @Autowired
    private ProductCategoryService productCategoryService;

    @PostMapping("/create")
    @Operation(summary = "创建客户需求")
    public CommonResult<Long> createCustomerRequire(@Valid @RequestBody CustomerRequireSaveReqVO createReqVO) {
        createReqVO.setCustomerId(customerApi.queryCustomerIdByUserId(SecurityFrameworkUtils.getLoginUserId()));
        return success(customerRequireService.createCustomerRequire(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新客户需求")
    public CommonResult<Boolean> updateCustomerRequire(@Valid @RequestBody CustomerRequireSaveReqVO updateReqVO) {
        updateReqVO.setCustomerId(customerApi.queryCustomerIdByUserId(SecurityFrameworkUtils.getLoginUserId()));
        customerRequireService.updateCustomerRequire(updateReqVO);
        return success(true);
    }

    @GetMapping("/get")
    @Operation(summary = "获得客户需求")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    public CommonResult<CustomerRequireRespVO> getCustomerRequire(@RequestParam("id") Long id) {
        CustomerRequireDO customerRequire = customerRequireService.getCustomerRequire(id);
        return success(BeanUtils.toBean(customerRequire, CustomerRequireRespVO.class, item -> {
            item.setCategoryName(productCategoryService.queryNameById(customerRequire.getCategoryId()));
        }));
    }

    @GetMapping("/page")
    @Operation(summary = "获得客户需求分页")
    public CommonResult<PageResult<CustomerRequireRespVO>> getCustomerRequirePage(@Valid CustomerRequirePageReqVO pageReqVO) {
        pageReqVO.setCreator(SecurityFrameworkUtils.getLoginUserId());
        PageResult<CustomerRequireDO> pageResult = customerRequireService.getCustomerRequirePage(pageReqVO);
        Map<Long, String> map = productCategoryService.getMap(CommonUtil.listConvertSet(pageResult.getList(), CustomerRequireDO::getCategoryId));
        return success(BeanUtils.toBean(pageResult, CustomerRequireRespVO.class, item -> {
            MapUtils.findAndThen(map, item.getCategoryId(), item::setCategoryName);
        }));
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除客户需求")
    @Parameter(name = "id", description = "编号", required = true)
    public CommonResult<Boolean> deleteCustomerRequire(@RequestParam("id") Long id) {
        customerRequireService.deleteCustomerRequire(id);
        return success(true);
    }

    @DeleteMapping("/delete-list")
    @Parameter(name = "ids", description = "编号", required = true)
    @Operation(summary = "批量删除客户需求")
    public CommonResult<Boolean> deleteCustomerRequireList(@RequestParam("ids") List<Long> ids) {
        customerRequireService.deleteCustomerRequireListByIds(ids);
        return success(true);
    }

}