package cn.iocoder.foodnexus.module.operations.controller.admin.scoringweight.vo;

import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import cn.iocoder.foodnexus.framework.common.validation.InEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.math.BigDecimal;

@Schema(description = "管理后台 - 评分权重新增/修改 Request VO")
@Data
public class ScoringWeightSaveReqVO {

    @Schema(description = "评价指标名称", requiredMode = Schema.RequiredMode.REQUIRED, example = "赵六")
    @NotEmpty(message = "评价指标名称不能为空")
    private String scoreName;

    @Schema(description = "面向用户群体", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "面向用户群体不能为空")
    @InEnum(value = UserSystemEnum.class, message = "用户类型必须是 {value}")
    private String userSystem;

    @Schema(description = "排序")
    private Integer sort;

}