package cn.iocoder.foodnexus.module.erp.controller.admin.product.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 供应商关联商品新增/修改 Request VO")
@Data
public class ProductSupplierSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "23757")
    private Long id;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "19411")
    @NotNull(message = "商品id不能为空")
    private Long productId;

    @Schema(description = "供应商id", requiredMode = Schema.RequiredMode.REQUIRED, example = "3025")
    @NotNull(message = "供应商id不能为空")
    private Long supplierId;

}