package cn.iocoder.foodnexus.module.erp.api.vo.customer;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author : yanghao
 * create at:  2025/8/30  11:36
 * @description: 客户新增api
 */
@Data
public class CustomerAddReqVO {

    /**
     * 客户名称
     */
    @NotEmpty(message = "客户名称不能为空")
    private String name;

    /**
     * 联系人
     */
    private String contact;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 联系电话
     */
    private String telephone;

    /**
     * 电子邮箱
     */
    private String email;

    /**
     * 传真
     */
    private String fax;

    /**
     * 备注
     */
    private String remark;

    /**
     * 开启状态
     */
    @NotNull(message = "开启状态不能为空")
    private Integer status;

    /**
     * 排序
     */
    @NotNull(message = "排序不能为空")
    private Integer sort;

    /**
     * 纳税人识别号
     */
    private String taxNo;

    /**
     * 税率
     */
    private BigDecimal taxPercent;

    /**
     * 开户行
     */
    private String bankName;

    /**
     * 开户账号
     */
    private String bankAccount;

    /**
     * 开户地址
     */
    private String bankAddress;


    /**
     * 省份id
     */
    private String provinceId;

    /**
     * 省份name
     */
    private String provinceName;

    /**
     * 市id
     */
    private String cityId;

    /**
     * 市name
     */
    private String cityName;

    /**
     * 地区id
     */
    private String regionId;

    /**
     * 地区name
     */
    private String regionName;

    /**
     * 详细地址
     */
    private String address;

}
