package cn.iocoder.foodnexus.module.customerpermission.core.aop;

import cn.iocoder.foodnexus.module.customerpermission.core.annotation.CustomerVisible;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;

/**
 * {@link CustomerVisible} 注解的 Advisor 实现类
 *
 * @author 芋道源码
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class CustomerPermissionAnnotationAdvisor extends AbstractPointcutAdvisor {

    private final Advice advice;

    private final Pointcut pointcut;

    public CustomerPermissionAnnotationAdvisor() {
        this.advice = new CustomerPermissionAnnotationInterceptor();
        this.pointcut = this.buildPointcut();
    }

    protected Pointcut buildPointcut() {
        Pointcut classPointcut = new AnnotationMatchingPointcut(CustomerVisible.class, true);
        Pointcut methodPointcut = new AnnotationMatchingPointcut(null, CustomerVisible.class, true);
        return new ComposablePointcut(classPointcut).union(methodPointcut);
    }

}
