package cn.iocoder.foodnexus.framework.common.pojo;

import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/10/30  17:58
 * @description: 导入结果
 */
@Data
@AllArgsConstructor
@Builder
public class ImportResult<T> {

    public ImportResult() {
        this.list = Lists.newArrayList();
        this.errorMsg = Lists.newArrayList();
    }

    @Schema(description = "导入结果集合")
    private List<T> list;

    @Schema(description = "导入总数")
    private Integer totalCount;

    @Schema(description = "成功数")
    private Integer successCount;

    @Schema(description = "失败数")
    private Integer errorCount;

    @Schema(description = "失败信息")
    private List<ErrorMsg> errorMsg;

    public void putError(Integer errorRow, String msg, String content) {
        errorMsg.add(new ErrorMsg(errorRow, msg, content));
    }

    public void add(T data) {
        list.add(data);
    }

    @Data
    @AllArgsConstructor
    public static class ErrorMsg {

        @Schema(description = "失败行数")
        private Integer errorRow;

        @Schema(description = "失败原因")
        private String msg;

        @Schema(description = "内容")
        private String content;

    }

}
