package cn.iocoder.foodnexus.module.operations.controller.admin.inquiresupplierpush.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/9/2  14:08
 * @description: 供应商 - 询价推送 - 确认
 */
@Data
public class AppInquireSupplierPushConfirmReqVO {

    @Schema(description = "询价主题 - id")
    @NotNull(message = "询价主题不能为空")
    private Long inquirePriceId;

    @Schema(hidden = true)
    private Long supplierId;

    @Schema(description = "子项")
    @Valid
    @NotNull(message = "子项不能为空")
    @Size(min = 1, message = "子项不能为空")
    private List<Item> items;

    @Data
    public static class Item {

        @Schema(description = "商品id")
        @NotNull(message = "商品不能为空")
        private Long productId;

        @Schema(description = "报价（分）")
        @NotNull(message = "报价不能为空")
        private Integer supplierQuote;

    }
}
