package cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.order;

import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.module.erp.enums.SaleOrderPickUpStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

/**
 * @author : yanghao
 * create at:  2025/10/15  17:07
 * @description:
 */
@Data
public class DeliveryOrderPageReqVO extends PageParam {

    @Schema(description = "接单时间段")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime acceptTimeBegin;

    @Schema(description = "接单时间段")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime acceptTimeEnd;

    @Schema(description = "拣货状态")
    private SaleOrderPickUpStatus pickUpStatus;

    @Schema(description = "订单类型（1-配送单 2-退货单）")
    private Integer type;

    @Schema(description = "配送员id", hidden = true)
    private Long deliveryStaffId;

}
