package cn.iocoder.foodnexus.module.order.service.orderScore;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import cn.iocoder.foodnexus.module.order.controller.admin.orderScore.vo.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.orderScore.OrderScoreDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.order.dal.mysql.orderScore.OrderScoreMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.convertList;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.diffList;
import static cn.iocoder.foodnexus.module.order.enums.ErrorCodeConstants.*;

/**
 * 订单评价 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class OrderScoreServiceImpl implements OrderScoreService {

    @Resource
    private OrderScoreMapper scoreMapper;

    @Override
    public Long createScore(OrderScoreSaveReqVO createReqVO) {
        // 插入
        OrderScoreDO score = BeanUtils.toBean(createReqVO, OrderScoreDO.class);
        scoreMapper.insert(score);

        // 返回
        return score.getId();
    }

    @Override
    public void updateScore(OrderScoreSaveReqVO updateReqVO) {
        // 校验存在
        validateScoreExists(updateReqVO.getId());
        // 更新
        OrderScoreDO updateObj = BeanUtils.toBean(updateReqVO, OrderScoreDO.class);
        scoreMapper.updateById(updateObj);
    }

    @Override
    public void deleteScore(Long id) {
        // 校验存在
        validateScoreExists(id);
        // 删除
        scoreMapper.deleteById(id);
    }

    @Override
        public void deleteScoreListByIds(List<Long> ids) {
        // 删除
        scoreMapper.deleteByIds(ids);
        }


    private void validateScoreExists(Long id) {
        if (scoreMapper.selectById(id) == null) {
            throw exception(SCORE_NOT_EXISTS);
        }
    }

    @Override
    public OrderScoreDO getScore(Long id) {
        return scoreMapper.selectById(id);
    }

    @Override
    public PageResult<OrderScoreDO> getScorePage(OrderScorePageReqVO pageReqVO) {
        return scoreMapper.selectPage(pageReqVO);
    }

    @Override
    public Integer queryScore(Long customerOrderId, Long scoreId) {
        OrderScoreDO orderScoreDO = scoreMapper.selectOne(Wrappers.<OrderScoreDO>lambdaQuery()
                .eq(OrderScoreDO::getOrderId, customerOrderId)
                .eq(OrderScoreDO::getScoreId, scoreId));
        return Optional.ofNullable(orderScoreDO).map(OrderScoreDO::getScore).orElse(null);
    }

    @Override
    public boolean exists(Long customerOrderId, Long scoreId) {
        return scoreMapper.exists(Wrappers.<OrderScoreDO>lambdaQuery()
                .eq(OrderScoreDO::getOrderId, customerOrderId)
                .eq(OrderScoreDO::getScoreId, scoreId));
    }

}