package cn.iocoder.foodnexus.module.order.service.orderScore;

import java.util.*;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.order.controller.admin.orderScore.vo.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.orderScore.OrderScoreDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 订单评价 Service 接口
 *
 * @author 超级管理员
 */
public interface OrderScoreService {

    /**
     * 创建订单评价
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createScore(@Valid OrderScoreSaveReqVO createReqVO);

    /**
     * 更新订单评价
     *
     * @param updateReqVO 更新信息
     */
    void updateScore(@Valid OrderScoreSaveReqVO updateReqVO);

    /**
     * 删除订单评价
     *
     * @param id 编号
     */
    void deleteScore(Long id);

    /**
    * 批量删除订单评价
    *
    * @param ids 编号
    */
    void deleteScoreListByIds(List<Long> ids);

    /**
     * 获得订单评价
     *
     * @param id 编号
     * @return 订单评价
     */
    OrderScoreDO getScore(Long id);

    /**
     * 获得订单评价分页
     *
     * @param pageReqVO 分页查询
     * @return 订单评价分页
     */
    PageResult<OrderScoreDO> getScorePage(OrderScorePageReqVO pageReqVO);

    Integer queryScore(Long customerOrderId, Long scoreId);

    boolean exists(Long customerOrderId, Long scoreId);

}