package cn.iocoder.foodnexus.module.order.dal.mysql.customerorder;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.query.QueryWrapperX;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorder.CustomerOrderDO;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo.*;

/**
 * 客户总订单 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface CustomerOrderMapper extends BaseMapperX<CustomerOrderDO> {

    default PageResult<CustomerOrderDO> selectPage(CustomerOrderPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<CustomerOrderDO>()
                .inIfPresent(CustomerOrderDO::getId, reqVO.getIds())
                .eqIfPresent(CustomerOrderDO::getCode, reqVO.getCode())
                .eqIfPresent(CustomerOrderDO::getOrderStatus, reqVO.getOrderStatus())
                .inIfPresent(CustomerOrderDO::getOrderStatus, reqVO.getOrderStatusList())
                .eqIfPresent(CustomerOrderDO::getCustomerId, reqVO.getCustomerId())
                .eqIfPresent(CustomerOrderDO::getWarehouseId, reqVO.getWarehouseId())
                .eqIfPresent(CustomerOrderDO::getWarehouseAreaId, reqVO.getWarehouseAreaId())
                .eqIfPresent(CustomerOrderDO::getWarehouseInfo, reqVO.getWarehouseInfo())
                .eqIfPresent(CustomerOrderDO::getDeliveryMode, reqVO.getDeliveryMode())
                .eqIfPresent(CustomerOrderDO::getProductCount, reqVO.getProductCount())
                .eqIfPresent(CustomerOrderDO::getSupplierCount, reqVO.getSupplierCount())
                .betweenIfPresent(CustomerOrderDO::getPlanDeliveryStartTime, reqVO.getPlanDeliveryStartTime())
                .betweenIfPresent(CustomerOrderDO::getPlanDeliveryEndTime, reqVO.getPlanDeliveryEndTime())
                .eqIfPresent(CustomerOrderDO::getOrderAmount, reqVO.getOrderAmount())
                .eqIfPresent(CustomerOrderDO::getActualAmount, reqVO.getActualAmount())
                .eqIfPresent(CustomerOrderDO::getOperCompany, reqVO.getOperCompany())
                .betweenIfPresent(CustomerOrderDO::getCreateTime, reqVO.getCreateTime())
                .eqIfPresent(CustomerOrderDO::getCreator, reqVO.getCreator())
                .orderByDesc(CustomerOrderDO::getId));
    }

    default List<Map<String, Object>> queryStatusCount(Long loginUserId) {
        QueryWrapperX<CustomerOrderDO> queryWrapper = new QueryWrapperX<>();
        queryWrapper.select("order_status, count(*) as 'status_count'");
        queryWrapper.eq("creator", loginUserId);
        queryWrapper.groupBy("order_status");
        return this.selectMaps(queryWrapper);
    }
}