package cn.iocoder.foodnexus.module.order.controller.admin.orderScore.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 订单评价 Response VO")
@Data
@ExcelIgnoreUnannotated
public class OrderScoreRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "12656")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "客户订单id", requiredMode = Schema.RequiredMode.REQUIRED, example = "4107")
    @ExcelProperty("客户订单id")
    private Long orderId;

    @Schema(description = "评价指标id", requiredMode = Schema.RequiredMode.REQUIRED, example = "15052")
    @ExcelProperty("评价指标id")
    private Long scoreId;

    @Schema(description = "评价指标名称", example = "芋艿")
    @ExcelProperty("评价指标名称")
    private String scoreName;

    @Schema(description = "供应商id", requiredMode = Schema.RequiredMode.REQUIRED, example = "23453")
    @ExcelProperty("供应商id")
    private Set<Long> supplierIds;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "7606")
    @ExcelProperty("客户id")
    private Long customerId;

    @Schema(description = "得分", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("得分")
    private Integer score;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}