package cn.iocoder.foodnexus.module.order.controller.admin.customerorderrecord.vo;

import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;
import cn.iocoder.foodnexus.framework.excel.core.annotations.DictFormat;
import cn.iocoder.foodnexus.framework.excel.core.convert.DictConvert;

@Schema(description = "管理后台 - 客户订单进度记录 Response VO")
@Data
@ExcelIgnoreUnannotated
public class CustomerOrderRecordRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "19592")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "客户订单id", requiredMode = Schema.RequiredMode.REQUIRED, example = "14294")
    @ExcelProperty("客户订单id")
    private Long customerOrderId;

    @Schema(description = "订单状态", requiredMode = Schema.RequiredMode.REQUIRED, example = "1")
    @ExcelProperty(value = "订单状态", converter = DictConvert.class)
    @DictFormat("order_customer_order_status") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private CustomerOrderStatus orderStatus;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "28995")
    @ExcelProperty("客户id")
    private Long customerId;

    @Schema(description = "供应商id", example = "8073")
    @ExcelProperty("供应商id")
    private Long supplierId;

    @Schema(description = "信息")
    @ExcelProperty("信息")
    private String messageInfo;

    @Schema(description = "扩展信息")
    @ExcelProperty("扩展信息")
    private String extendInfo;

    @Schema(description = "创建者")
    @ExcelProperty("创建者")
    private String creator;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}