package cn.iocoder.foodnexus.module.order.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author : yanghao
 * create at:  2025/9/5  17:16
 * @description: 客户 - 订单 - 配送模式
 */
@Getter
@AllArgsConstructor
public enum DeliveryMode implements ArrayValuable<String> {

    NORMAL("普通配送", "NORMAL"),

    PRESSING("紧急配送", "PRESSING"),

    ;

    private final String label;
    private final String key;

    public static final String[] ARRAYS = Arrays.stream(values()).map(DeliveryMode::getKey).toArray(String[]::new);

    /**
     * @return 数组
     */
    @Override
    public String[] array() {
        return ARRAYS;
    }
}
