package cn.iocoder.foodnexus.module.operations.service.vehicleinfo;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.vehicleinfo.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.vehicleinfo.VehicleInfoDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.operations.dal.mysql.vehicleinfo.VehicleInfoMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.convertList;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.diffList;
import static cn.iocoder.foodnexus.module.operations.enums.ErrorCodeConstants.*;

/**
 * 车辆信息 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class VehicleInfoServiceImpl implements VehicleInfoService {

    @Resource
    private VehicleInfoMapper vehicleInfoMapper;

    @Override
    public Long createVehicleInfo(VehicleInfoSaveReqVO createReqVO) {
        // 插入
        VehicleInfoDO vehicleInfo = BeanUtils.toBean(createReqVO, VehicleInfoDO.class);
        vehicleInfoMapper.insert(vehicleInfo);

        // 返回
        return vehicleInfo.getId();
    }

    @Override
    public void updateVehicleInfo(VehicleInfoSaveReqVO updateReqVO) {
        // 校验存在
        validateVehicleInfoExists(updateReqVO.getId());
        // 更新
        VehicleInfoDO updateObj = BeanUtils.toBean(updateReqVO, VehicleInfoDO.class);
        vehicleInfoMapper.updateById(updateObj);
    }

    @Override
    public void deleteVehicleInfo(Long id) {
        // 校验存在
        validateVehicleInfoExists(id);
        // 删除
        vehicleInfoMapper.deleteById(id);
    }

    @Override
        public void deleteVehicleInfoListByIds(List<Long> ids) {
        // 删除
        vehicleInfoMapper.deleteByIds(ids);
        }


    private void validateVehicleInfoExists(Long id) {
        if (vehicleInfoMapper.selectById(id) == null) {
            throw exception(VEHICLE_INFO_NOT_EXISTS);
        }
    }

    @Override
    public VehicleInfoDO getVehicleInfo(Long id) {
        return vehicleInfoMapper.selectById(id);
    }

    @Override
    public PageResult<VehicleInfoDO> getVehicleInfoPage(VehicleInfoPageReqVO pageReqVO) {
        return vehicleInfoMapper.selectPage(pageReqVO);
    }

    @Override
    public void vehicleBind(VehicleInfoBindReqVO updateReqVO) {
        // 校验存在
        validateVehicleInfoExists(updateReqVO.getId());
        // 更新
        vehicleInfoMapper.update(Wrappers.<VehicleInfoDO>lambdaUpdate()
                .set(VehicleInfoDO::getVehicleStaff, updateReqVO.getVehicleStaff())
                .set(VehicleInfoDO::getVehicleStaffName, updateReqVO.getVehicleStaffName())
                .set(VehicleInfoDO::getStaffYearBirth, updateReqVO.getStaffYearBirth())
                .set(VehicleInfoDO::getStaffPhone, updateReqVO.getStaffPhone())
                .set(VehicleInfoDO::getStaffHealthStatus, updateReqVO.getStaffHealthStatus())
                .set(VehicleInfoDO::getStaffLicenseStatus, updateReqVO.getStaffLicenseStatus())
                .eq(VehicleInfoDO::getId, updateReqVO.getId()));
    }

    @Override
    public void releaseBind(Long id) {
        VehicleInfoDO vehicleInfoDO = vehicleInfoMapper.selectById(id);
        if (vehicleInfoDO == null) {
            throw exception(VEHICLE_INFO_NOT_EXISTS);
        }
        if (vehicleInfoDO.getVehicleStaff() == null) {
            throw exception(VEHICLE_STAFF_NOT_EXISTS);
        }
        vehicleInfoMapper.update(Wrappers.<VehicleInfoDO>lambdaUpdate()
                        .set(VehicleInfoDO::getVehicleStaff, null)
                        .set(VehicleInfoDO::getVehicleStaffName, null)
                        .set(VehicleInfoDO::getStaffYearBirth, null)
                        .set(VehicleInfoDO::getStaffPhone, null)
                        .set(VehicleInfoDO::getStaffHealthStatus, null)
                        .set(VehicleInfoDO::getStaffLicenseStatus, null)
                        .eq(VehicleInfoDO::getId, id));
    }

    @Override
    public VehicleInfoRespVO queryByStaffId(Long staffId) {
        return BeanUtils.toBean(vehicleInfoMapper.selectOne(Wrappers.<VehicleInfoDO>lambdaQuery()
                .eq(VehicleInfoDO::getVehicleStaff, staffId)
                .last("LIMIT 1")), VehicleInfoRespVO.class);
    }

}