package cn.iocoder.foodnexus.module.operations.enums;

import cn.iocoder.foodnexus.framework.common.exception.ErrorCode;

/**
 * Product 错误码枚举类
 *
 * product 系统，使用 1-008-000-000 段
 */
public interface ErrorCodeConstants {

    // ========== 车辆信息 ==========
    ErrorCode VEHICLE_INFO_NOT_EXISTS = new ErrorCode(1_008_010_000, "车辆信息不存在");
    ErrorCode VEHICLE_STAFF_NOT_EXISTS = new ErrorCode(1_008_010_001, "车辆未绑定人员");


    // ========== 配送员信息 1_008_011_000 ==========
    ErrorCode DELIVERY_STAFF_NOT_EXISTS = new ErrorCode(1_008_011_000, "配送员信息不存在");

    // ========== 配送员客户绑定 1_008_012_000 ==========
    ErrorCode DELIVERY_STAFF_CUSTOMER_NOT_EXISTS = new ErrorCode(1_008_012_000, "配送员客户绑定不存在");

    // ========== 询价管理 1_008_013_000 ==========
    ErrorCode INQUIRE_PRICE_NOT_EXISTS = new ErrorCode(1_008_013_000, "询价管理不存在");
    ErrorCode INQUIRE_PRICE_PUSHED = new ErrorCode(1_008_013_001, "询价管理已推送");
    ErrorCode INQUIRE_PRICE_CUSTOMER_NOT_EXISTS = new ErrorCode(1_008_013_002, "客户信息异常，请检查推送客户信息");

    // ========== 询价管理子 1_008_014_000 ==========
    ErrorCode INQUIRE_PRICE_ITEM_NOT_EXISTS = new ErrorCode(1_008_014_000, "询价管理子不存在");

    // ========== 询价推送-客户 1_008_015_000 ==========
    ErrorCode INQUIRE_CUSTOMER_PUSH_NOT_EXISTS = new ErrorCode(1_008_015_000, "询价推送-客户不存在");

    // ========== 询价推送 1_008_016_000 ==========
    ErrorCode INQUIRE_SUPPLIER_PUSH_NOT_EXISTS = new ErrorCode(1_008_016_000, "询价推送不存在");

    // ========== 客户需求 1_008_017_000 ==========
    ErrorCode CUSTOMER_REQUIRE_NOT_EXISTS = new ErrorCode(1_008_017_000, "客户需求不存在");
    ErrorCode CUSTOMER_REQUIRE_IS_REQUIRE = new ErrorCode(1_008_017_001, "客户需求已受理");

    // ========== 评分权重 1_008_018_000 ==========
    ErrorCode SCORING_WEIGHT_NOT_EXISTS = new ErrorCode(1_008_018_000, "评分权重不存在");
}
