package cn.iocoder.foodnexus.module.operations.controller.admin.scoringweight.vo;

import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import cn.iocoder.foodnexus.framework.common.enums.UserTypeEnum;
import cn.iocoder.foodnexus.framework.common.validation.InEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;
import java.math.BigDecimal;

@Schema(description = "管理后台 - 评分权重新增/修改 Request VO")
@Data
public class ScoringWeightSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "8877")
    private Long id;

    @Schema(description = "评价指标名称", requiredMode = Schema.RequiredMode.REQUIRED, example = "赵六")
    @NotEmpty(message = "评价指标名称不能为空")
    private String scoreName;

    @Schema(description = "评分权重", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "评分权重不能为空")
    private BigDecimal weightRatio;

    @Schema(description = "是否展示", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "是否展示不能为空")
    private Boolean isDisplay;

    @Schema(description = "面向用户群体", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "面向用户群体不能为空")
    @InEnum(value = UserSystemEnum.class, message = "用户类型必须是 {value}")
    private String userSystem;

    @Schema(description = "排序")
    private Integer sort;

}