package cn.iocoder.foodnexus.module.erp.dal.dataobject.sale;

import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.product.ErpProductDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.stock.ErpWarehouseDO;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;

import java.math.BigDecimal;

/**
 * ERP 销售退货项 DO
 *
 * @author 芋道源码
 */
@TableName("erp_sale_return_items")
@KeySequence("erp_sale_return_items_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ErpSaleReturnItemDO extends BaseDO {

    /**
     * 编号
     */
    @TableId
    private Long id;
    /**
     * 销售退货编号
     *
     * 关联 {@link ErpSaleReturnDO##getId()}
     */
    private Long returnId;
    /**
     * 销售订单项编号
     *
     * 关联 {@link ErpSaleOrderItemDO#getId()}
     * 目的：方便更新关联的销售订单项的退货数量
     */
    private Long orderItemId;
    /**
     * 客户订单子项id
     */
    private Long customerOrderItemId;
    /**
     * 仓库编号
     *
     * 关联 {@link ErpWarehouseDO#getId()}
     */
    private Long warehouseId;
    /**
     * 产品编号
     *
     * 关联 {@link ErpProductDO#getId()}
     */
    private Long productId;
    /**
     * 产品单位单位
     */
    private String productUnit;

    /**
     * 产品单位单价，单位：分
     */
    private Integer productPrice;
    /**
     * 数量
     */
    private Integer count;
    /**
     * 总价，单位：分
     *
     * totalPrice = productPrice * count
     */
    private Integer totalPrice;
    /**
     * 税率，百分比
     */
    private BigDecimal taxPercent;
    /**
     * 税额，单位：分
     *
     * taxPrice = totalPrice * taxPercent
     */
    private BigDecimal taxPrice;

    /**
     * 备注
     */
    private String remark;

    /**
     * 供应商
     */
    private Long supplierId;

}