package cn.iocoder.foodnexus.module.erp.dal.dataobject.sale;

import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;
import cn.iocoder.foodnexus.module.erp.api.enums.ErpAuditStatus;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.finance.ErpAccountDO;
import cn.iocoder.foodnexus.module.order.dto.CustomerAddressInfo;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import lombok.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * ERP 销售出库 DO
 *
 * @author 芋道源码
 */
@TableName(value = "erp_sale_out", autoResultMap = true)
@KeySequence("erp_sale_out_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ErpSaleOutDO extends BaseDO {

    /**
     * 编号
     */
    @TableId
    private Long id;
    /**
     * 销售出库单号
     */
    private String no;
    /**
     * 出库状态
     *
     * 枚举 {@link ErpAuditStatus}
     */
    private Integer status;
    /**
     * 客户编号
     *
     * 关联 {@link ErpCustomerDO#getId()}
     */
    private Long customerId;
    /**
     * 结算账户编号
     *
     * 关联 {@link ErpAccountDO#getId()}
     */
    private Long accountId;
    /**
     * 销售员编号
     *
     * 关联 AdminUserDO 的 id 字段
     */
    private Long saleUserId;
    /**
     * 出库时间
     */
    private LocalDateTime outTime;

    /**
     * 销售订单编号
     *
     * 关联 {@link ErpSaleOrderDO#getId()}
     */
    private Long orderId;
    /**
     * 销售订单号
     *
     * 冗余 {@link ErpSaleOrderDO#getNo()}
     */
    private String orderNo;

    /**
     * 合计数量
     */
    private Integer totalCount;
    /**
     * 最终合计价格，单位：分
     *
     * totalPrice = totalProductPrice + totalTaxPrice - discountPrice + otherPrice
     */
    private Integer totalPrice;
    /**
     * 已收款金额，单位：分
     *
     * 目的：和 {@link cn.iocoder.foodnexus.module.erp.dal.dataobject.finance.ErpFinanceReceiptDO} 结合，记录已收款金额
     */
    private BigDecimal receiptPrice;

    /**
     * 合计产品价格，单位：分
     */
    private Integer totalProductPrice;
    /**
     * 合计税额，单位：分
     */
    private BigDecimal totalTaxPrice;
    /**
     * 优惠率，百分比
     */
    private BigDecimal discountPercent;
    /**
     * 优惠金额，单位：分
     *
     * discountPrice = (totalProductPrice + totalTaxPrice) * discountPercent
     */
    private BigDecimal discountPrice;
    /**
     * 其它金额，单位：分
     */
    private BigDecimal otherPrice;

    /**
     * 附件地址
     */
    private String fileUrl;
    /**
     * 备注
     */
    private String remark;

    /**
     * 客户订单id
     */
    private Long customerOrderId;

    /**
     * 配送模式
     *
     * 枚举 {@link DeliveryMode}
     */
    private DeliveryMode deliveryMode;

    /**
     * 配送时间
     */
    private LocalDateTime deliveryTime;

    /**
     * 配送人员
     *
     * DeliveryStaffDO
     */
    private Long deliveryStaffId;

    /**
     * 客户收货地址id
     */
    private Long addressId;

    /**
     * 客户收货地址info
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private CustomerAddressInfo addressInfo;
}