package cn.iocoder.foodnexus.module.erp.controller.admin.purchase.vo.order;

import cn.idev.excel.annotation.ExcelProperty;
import cn.iocoder.foodnexus.framework.excel.core.annotations.DictFormat;
import cn.iocoder.foodnexus.framework.excel.core.convert.DictConvert;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author : yanghao
 * create at:  2025/10/11  13:53
 * @description: 月度账单明细
 */
@Data
public class SupplierMonthOrderDetailsRespVO extends ErpPurchaseOrderRespVO {

    @Schema(description = "配送模式", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty(value = "配送模式", converter = DictConvert.class)
    @DictFormat("order_delivery_mode") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private DeliveryMode deliveryMode;

    @Schema(description = "预计配送开始时间")
    @ExcelProperty("预计配送开始时间")
    private LocalDateTime planDeliveryStartTime;

    @Schema(description = "预计配送结束时间")
    @ExcelProperty("预计配送结束时间")
    private LocalDateTime planDeliveryEndTime;

    @Schema(description = "应对账总金额(分)")
    private Integer payablePrice;

    @Schema(description = "签收金额")
    private Integer signedTotal;

    @Schema(description = "退款金额")
    private Integer returnsTotal;
}
