package cn.iocoder.foodnexus.module.order.dal.mysql.customerorder;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorder.CustomerOrderDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo.*;

/**
 * 客户总订单 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface CustomerOrderMapper extends BaseMapperX<CustomerOrderDO> {

    default PageResult<CustomerOrderDO> selectPage(CustomerOrderPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<CustomerOrderDO>()
                .eqIfPresent(CustomerOrderDO::getCode, reqVO.getCode())
                .eqIfPresent(CustomerOrderDO::getOrderStatus, reqVO.getOrderStatus())
                .eqIfPresent(CustomerOrderDO::getCustomerId, reqVO.getCustomerId())
                .eqIfPresent(CustomerOrderDO::getWarehouseId, reqVO.getWarehouseId())
                .eqIfPresent(CustomerOrderDO::getWarehouseAreaId, reqVO.getWarehouseAreaId())
                .eqIfPresent(CustomerOrderDO::getWarehouseInfo, reqVO.getWarehouseInfo())
                .eqIfPresent(CustomerOrderDO::getDeliveryMode, reqVO.getDeliveryMode())
                .eqIfPresent(CustomerOrderDO::getProductCount, reqVO.getProductCount())
                .eqIfPresent(CustomerOrderDO::getSupplierCount, reqVO.getSupplierCount())
                .betweenIfPresent(CustomerOrderDO::getPlanDeliveryStartTime, reqVO.getPlanDeliveryStartTime())
                .betweenIfPresent(CustomerOrderDO::getPlanDeliveryEndTime, reqVO.getPlanDeliveryEndTime())
                .eqIfPresent(CustomerOrderDO::getOrderAmount, reqVO.getOrderAmount())
                .eqIfPresent(CustomerOrderDO::getActualAmount, reqVO.getActualAmount())
                .eqIfPresent(CustomerOrderDO::getOperCompany, reqVO.getOperCompany())
                .betweenIfPresent(CustomerOrderDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(CustomerOrderDO::getId));
    }

}