package cn.iocoder.foodnexus.module.order.controller.app.customeraddress;

import cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo.CustomerAddressPageReqVO;
import cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo.CustomerAddressRespVO;
import cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo.CustomerAddressSaveReqVO;
import org.springframework.web.bind.annotation.*;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Operation;

import jakarta.validation.*;
import jakarta.servlet.http.*;
import java.util.*;
import java.io.IOException;

import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

import cn.iocoder.foodnexus.framework.excel.core.util.ExcelUtils;

import cn.iocoder.foodnexus.framework.apilog.core.annotation.ApiAccessLog;
import static cn.iocoder.foodnexus.framework.apilog.core.enums.OperateTypeEnum.*;

import cn.iocoder.foodnexus.module.order.dal.dataobject.customeraddress.CustomerAddressDO;
import cn.iocoder.foodnexus.module.order.service.customeraddress.CustomerAddressService;

@Tag(name = "APP - 客户 - 我的地址")
@RestController
@RequestMapping("/order/customer-address")
@Validated
public class CustomerAddressController {

    @Resource
    private CustomerAddressService customerAddressService;

    @PostMapping("/create")
    @Operation(summary = "创建客户 - 我的地址")
    @PreAuthorize("@ss.hasPermission('order:customer-address:create')")
    public CommonResult<Long> createCustomerAddress(@Valid @RequestBody CustomerAddressSaveReqVO createReqVO) {
        return success(customerAddressService.createCustomerAddress(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新客户 - 我的地址")
    @PreAuthorize("@ss.hasPermission('order:customer-address:update')")
    public CommonResult<Boolean> updateCustomerAddress(@Valid @RequestBody CustomerAddressSaveReqVO updateReqVO) {
        customerAddressService.updateCustomerAddress(updateReqVO);
        return success(true);
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除客户 - 我的地址")
    @Parameter(name = "id", description = "编号", required = true)
    @PreAuthorize("@ss.hasPermission('order:customer-address:delete')")
    public CommonResult<Boolean> deleteCustomerAddress(@RequestParam("id") Long id) {
        customerAddressService.deleteCustomerAddress(id);
        return success(true);
    }

    @DeleteMapping("/delete-list")
    @Parameter(name = "ids", description = "编号", required = true)
    @Operation(summary = "批量删除客户 - 我的地址")
                @PreAuthorize("@ss.hasPermission('order:customer-address:delete')")
    public CommonResult<Boolean> deleteCustomerAddressList(@RequestParam("ids") List<Long> ids) {
        customerAddressService.deleteCustomerAddressListByIds(ids);
        return success(true);
    }

    @GetMapping("/get")
    @Operation(summary = "获得客户 - 我的地址")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    @PreAuthorize("@ss.hasPermission('order:customer-address:query')")
    public CommonResult<CustomerAddressRespVO> getCustomerAddress(@RequestParam("id") Long id) {
        CustomerAddressDO customerAddress = customerAddressService.getCustomerAddress(id);
        return success(BeanUtils.toBean(customerAddress, CustomerAddressRespVO.class));
    }

    @GetMapping("/page")
    @Operation(summary = "获得客户 - 我的地址分页")
    @PreAuthorize("@ss.hasPermission('order:customer-address:query')")
    public CommonResult<PageResult<CustomerAddressRespVO>> getCustomerAddressPage(@Valid CustomerAddressPageReqVO pageReqVO) {
        PageResult<CustomerAddressDO> pageResult = customerAddressService.getCustomerAddressPage(pageReqVO);
        return success(BeanUtils.toBean(pageResult, CustomerAddressRespVO.class));
    }

}