package cn.iocoder.foodnexus.module.operations.dal.mysql.vehicleinfo;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.vehicleinfo.VehicleInfoDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.operations.controller.admin.vehicleinfo.vo.*;

/**
 * 车辆信息 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface VehicleInfoMapper extends BaseMapperX<VehicleInfoDO> {

    default PageResult<VehicleInfoDO> selectPage(VehicleInfoPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<VehicleInfoDO>()
                .eqIfPresent(VehicleInfoDO::getLicensePlate, reqVO.getLicensePlate())
                .eqIfPresent(VehicleInfoDO::getVehicleType, reqVO.getVehicleType())
                .eqIfPresent(VehicleInfoDO::getLoadWeight, reqVO.getLoadWeight())
                .eqIfPresent(VehicleInfoDO::getVolume, reqVO.getVolume())
                .eqIfPresent(VehicleInfoDO::getVehicleStaff, reqVO.getVehicleStaff())
                .likeIfPresent(VehicleInfoDO::getVehicleStaffName, reqVO.getVehicleStaffName())
                .eqIfPresent(VehicleInfoDO::getStaffYearBirth, reqVO.getStaffYearBirth())
                .eqIfPresent(VehicleInfoDO::getStaffPhone, reqVO.getStaffPhone())
                .eqIfPresent(VehicleInfoDO::getStaffHealthStatus, reqVO.getStaffHealthStatus())
                .eqIfPresent(VehicleInfoDO::getStaffLicenseStatus, reqVO.getStaffLicenseStatus())
                .betweenIfPresent(VehicleInfoDO::getCreateTime, reqVO.getCreateTime())
                .eqIfPresent(VehicleInfoDO::getCreator, reqVO.getCreator())
                .orderByDesc(VehicleInfoDO::getId));
    }

}